# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Publish a publishing page 
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to SharePoint site
$webUrl = "http://sharepoint/site"

# Title of page
$title = "PowerShell Page"

# Publish notes
$notes = "My publish notes."

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl
	
# Get the Publishing Site from the SharePoint Site
$pubWeb = [Microsoft.SharePoint.Publishing.PublishingWeb]::GetPublishingWeb($web)

# Create a CAML query to get the Page by its Title
$camlQuery = "<Where><Eq><FieldRef Name='Title'></FieldRef><Value Type='Text'>" + $title + "</Value></Eq></Where>"
	
# Get the Page with the CAML query
$page = $pubWeb.GetPublishingPages($camlQuery)

# Publish the Page
$page.ListItem.File.Publish($notes)

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 